// Checkpoint Chrome Extension - Background Service Worker

// Handle extension icon click - inject widget with extension ID
chrome.action.onClicked.addListener(async (tab) => {
  const extensionId = chrome.runtime.id;
  
  await chrome.scripting.executeScript({
    target: { tabId: tab.id },
    world: 'MAIN',
    func: (extId) => {
      // Set extension ID for pixel-perfect screenshots
      window.TEMPO_QA_EXTENSION_ID = extId;
      
      if (!document.getElementById('tempo-qa-widget')) {
        const s = document.createElement('script');
        s.src = 'https://tempo-qa.vercel.app/widget.js?t=' + Date.now();
        document.body.appendChild(s);
      }
    },
    args: [extensionId]
  });
});

// Handle screenshot requests from the widget
chrome.runtime.onMessageExternal.addListener((request, sender, sendResponse) => {
  if (request.type === 'captureScreenshot') {
    chrome.tabs.captureVisibleTab(null, { format: 'png' }, (dataUrl) => {
      if (chrome.runtime.lastError) {
        sendResponse({ error: chrome.runtime.lastError.message });
      } else {
        sendResponse({ dataUrl });
      }
    });
    return true; // Keep channel open for async response
  }
});
